//*********************************************************************************
//**
//** Platform........: ATMEL ATmega or AT90 series of Microcontrollers
//**
//** Licence.........: This software is freely available for non-commercial 
//**                   use only - i.e. for research and experimentation.
//**
//**                   A very simple polling type Rotary Encoder routine. 
//**
//**                   2010-08-05, Loftur Jonasson, TF3LJ
//**
//*********************************************************************************


#include "Att.h"

int16_t	encOutput;								// Output From Encoder
//
// Init Encoder for use
//
void encoder_Init(void)
{
	//
	// Set inputs with pullup
	//
	ENC_A_DDR &= ~ENC_A_PIN;					// Enable pin for input
	ENC_A_PORT |= ENC_A_PIN;					// Activate internal pullup resistor
    ENC_B_DDR &= ~ENC_B_PIN;
	ENC_B_PORT |= ENC_B_PIN;
}


//
// Scan the Shaft Encoder
//
void encoder_Scan(void)
{
	static uint8_t old_pha, old_phb;			// Variables conaining the previous encoder states

	uint8_t pha = 0, phb= 0;					// Variables containing the current encoder states

	static int8_t	increment;					// This variable used to add up changes

	if (ENC_A_PORTIN & ENC_A_PIN) pha++;		// Read Phase A
	if (ENC_B_PORTIN & ENC_B_PIN) phb++;		// Read Phase B

	if ((pha != old_pha) && (phb != old_phb));	// Both states have changed, invalid
	
	else if (pha != old_pha)					// State of Phase A has changed
	{
		old_pha = pha;							// Store for next iteration

		if(old_pha != old_phb)					// Decide direction and
			#if	ENCODER_DIR_REVERSE
			increment--;						// increment
			#else
			increment++;						// increment
			#endif
		else
			#if	ENCODER_DIR_REVERSE
			increment++;						// or decrement
			#else
			increment--;						// or decrement
			#endif
	}
	
	else if (phb != old_phb)					// State of Phase B has changed
	{
		old_phb = phb;							// Store for next iteration

		if(old_pha != old_phb)					// Decide direction and
			#if	ENCODER_DIR_REVERSE
			increment ++;						// decrement
			#else
			increment --;						// decrement
			#endif
		else
			#if	ENCODER_DIR_REVERSE
			increment --;						// or increment
			#else
			increment ++;						// or increment
			#endif
	}

	encOutput += increment/R.encoderRes;		// Adjustable Encoder output resolution

	if (encOutput != 0)							// We have an output
	{
		increment = 0;
		Status |= ENC_CHANGE;					// Encoder state was changed
	}
}
