//*********************************************************************************
//**
//** Project.........: Magnetic Loop Controller
//**
//**
//** Copyright (C) 2014  Loftur E. Jonasson  (tf3lj [at] arrl [dot] net)
//**
//** This program is free software: you can redistribute it and/or modify
//** it under the terms of the GNU General Public License as published by
//** the Free Software Foundation, either version 3 of the License, or
//** (at your option) any later version.
//**
//** This program is distributed in the hope that it will be useful,
//** but WITHOUT ANY WARRANTY; without even the implied warranty of
//** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//** GNU General Public License for more details.
//**
//** You should have received a copy of the GNU General Public License
//** along with this program.  If not, see <http://www.gnu.org/licenses/>.
//**
//** Platform........: Teensy++ 2.0, Teensy 3 or Teensy 3.1 (http://www.pjrc.com)
//**                   (target platform is Teensy 3.1)
//**                   (Some other Arduino type platforms may also work
//**                    with no more than minimal tweaks being necessary)
//**
//** Initial version.: 0.00, 2012-10-20  Loftur Jonasson, TF3LJ / VE2LJX
//**                   (pre-alpha version)
//**
//** History.........: Check the ML_xx.c file
//**
//**
//*********************************************************************************

// For the latest version of the Magnetic Loop Controller Firmware, see webpage:
// https://sites.google.com/site/lofturj/to-automatically-tune-a-magnetic-loop-antenna
// This is a fork from an OLD and less capable version - maintaining compatibility with
// Teensy++ 2.0

#define          VERSION "0h94"
#define          DATE    "2015-01-24"

//
//-----------------------------------------------------------------------------
// Features Selection
//-----------------------------------------------------------------------------  
//                                

//-----------------------------------------------------------------------------
//DEFS for various Magloop specific paramenters
//

//-----------------------------------------------------------------------------
// Definitions for the Radio Frqeuency Input Information
// Select the appropriate one of the below:
//
#define TRX_CIV_AUTO         0   // ICOM style CI-V auto transmission of frequency data
#define TRX_CIV_POLL         1   // ICOM style CI-V poll of frequency data
//#define TRX_KENWOODxxxx    0   // Never owned a Kenwood RIG (yet) - NOT IMPLEMENTED
#define TRX_FT100_POLL       0   // Yaesu FT100 CAT poll
//#define TRX_FT1000_POLL    0   // Yaesu FT1000 - (1000 != 1000D != 1000MP etc) - NOT IMPLEMENTED
#define TRX_FT8X7_POLL       0   // Yaesu FT817/847/857/897 - Implemened, may work but not tested
#define TRX_FT2000_POLL      0   // Yaesu FT450/950/1200/2000/3000/5000 CAT poll
#define TRX_K3_AUTO          0   // Elecraft K3 / KX3 auto transmission of frequency data
#define TRX_K3_POLL          0   // Elecraft K3 / KX3 poll of frequency data

//
// The appropriate settings below are automatically selected based on the above choice
#if TRX_CIV_AUTO
#define ASYNC_SER_READ       1                    // Read anything off the serial port
#define USART_BAUD        1200                    // Baud rate of serial port
#define USART_CONFIG      SERIAL_8N1              // Bits/parity/stopbits
//#define USART_CONFIG    SERIAL_8N1_RXINV_TXINV  // Reverse polarity Serial (if RS232 without MAX232)
#define TRX_FREQUENCY_POLL   0
#define STARTUPDISPLAY3   "ICOM generic CI-V"     // Third line LCD indication at startup
#endif
//
#if TRX_CIV_POLL
#define ASYNC_SER_READ       1                    // Read anything off the serial port
#define CIV_TRX_ADDRESS   0x64                    // Default Address IC756proII
#define USART_BAUD        1200                    // Baud rate of serial port
#define USART_CONFIG      SERIAL_8N1              // Bits/parity/stopbits
//#define USART_CONFIG    SERIAL_8N1_RXINV_TXINV  // Reverse polarity Serial (if RS232 without MAX232)
#define TRX_FREQUENCY_POLL   1
#define STARTUPDISPLAY3   "ICOM CI-V poll"        // Third line LCD indication at startup
#endif
//
#if TRX_FT2000_POLL
#define ASYNC_SER_READ       1                    // Read anything off the serial port
#define USART_BAUD        38400                   // Baud rate of serial port
//#define USART_CONFIG      SERIAL_8N1              // Bits/parity/stopbits
#define USART_CONFIG    SERIAL_8N1_RXINV_TXINV  // Reverse polarity Serial (if RS232 without MAX232)
#define TRX_FREQUENCY_POLL   1
#define STARTUPDISPLAY3   "Yaesu FT450/950/2000"  // Third line LCD indication at startup
#endif
//
#if TRX_FT8X7_POLL
#define ASYNC_SER_READ       0                    // Read Polled Data only
#define USART_BAUD        4800                    // Baud rate of serial port
#define USART_CONFIG      SERIAL_8N2              // Bits/parity/stopbits
#define TRX_FREQUENCY_POLL   1
#define STARTUPDISPLAY3   "Yaesu FT8X7 CAT"       // Third line LCD indication at startup
#endif
//
#if TRX_FT100_POLL
#define ASYNC_SER_READ       0                    // Read Polled Data only
#define USART_BAUD        4800                    // Baud rate of serial port
#define USART_CONFIG      SERIAL_8N2              // Bits/parity/stopbits
#define TRX_FREQUENCY_POLL   1
#define STARTUPDISPLAY3   "Yaesu FT100 CAT"       // Third line LCD indication at startup
#endif
//
// The appropriate settings below are automatically selected based on the above choice
#if TRX_K3_AUTO
#define ASYNC_SER_READ       1                    // Read anything off the serial port
#define USART_BAUD        38400                   // Baud rate of serial port
#define USART_CONFIG      SERIAL_8N1              // Bits/parity/stopbits
//#define USART_CONFIG    SERIAL_8N1_RXINV_TXINV  // Reverse polarity Serial (if RS232 without MAX232)
#define TRX_FREQUENCY_POLL   0
#define STARTUPDISPLAY3   "Elecraft K3 generic"   // Third line LCD indication at startup
#endif
//
#if TRX_K3_POLL
#define ASYNC_SER_READ       1                    // Read anything off the serial port
#define USART_BAUD        38400                   // Baud rate of serial port
#define USART_CONFIG      SERIAL_8N1              // Bits/parity/stopbits
//#define USART_CONFIG    SERIAL_8N1_RXINV_TXINV  // Reverse polarity Serial (if RS232 without MAX232)
#define TRX_FREQUENCY_POLL   1
#define STARTUPDISPLAY3   "Elecraft K3 poll"      // Third line LCD indication at startup
#endif
//
// Usable Definitions for USART serial rate and configuration are available here:
// http://www.pjrc.com/teensy/td_uart.html
//

//-----------------------------------------------------------------------------
// Frequency Poll Rate
#define POLL_RATE         1000                    // Poll the Radio once every 2 seconds

//-----------------------------------------------------------------------------
// Definitions for the Stepper speed, Encoder and Menu/Enact Pushbutton functionality
#define STEPPER_MICROSTEPS   0    // 0 for full resolution of 8 microsteps
                                  // 1 for 4 microsteps, 2 for 2 microsteps
                                  // or 3 for no microsteps
                                  
#define  VARIABLE_RATE       4    // 8 for Eightfold Rate when tuning long distance
                                  // 4 for Quadruple Rate when tuning "long distance"
                                  // 2 for Double Rate when tuning "long distance"
                                  // or 1 for Fixed Rate
                                  // Note that max Stepper Rate will never be higher than
                                  // the equivalent rate resulting from the Stepper
                                  // resolution setting of 0 Microsteps (see User Menu
                                  // settings - through long push of Enact button).
                                  // For example if 2 Microsteps are selected, then the
                                  // Max possible rate will Double, regardless of the
                                  // VARIABLE_RATE definition being set at a higher value
                                  
#define  LOOP_RATE           2    // This is the maximum update rate for all
                                  // encoder tuning related routines.
                                  // A higher number will slow down the tune rate
                                  // Do not set lower than 2 (2 milliseconds)
                                  
#define  UP_DOWN_RATE       20    // Stepper rate reducer when using Up/Down switches
                                  // 0 = full speed, 4 = 1/4 speed, etc...
                                  
#define  ENACT_MIN           1    // Minimum Menu/Enact push for "short push" (x 100 ms)
#define  ENACT_MAX          10    // Minimum Menu/Enact push for Menu Mode (x 100 ms)
//
#define  ENC_MENURESDIVIDE  16    // Encoder resolution reduction when in Menu
#define  ENC_TUNERESDIVIDE   2    // Encoder resolution reduction when turning
                                  // stepper motor, 1 = no reduction.

//-----------------------------------------------------------------------------
// Definitions for Stepper Motor Backlash
// In order to counter Backlash in the coupling between the Stepper Motor and
// the Capacitor, always reposition the capacitor in an upwards tuning
// direction.  When tuning down, start by overshooting by BACKLASH number of
// microsteps, then tune up.  Since there are 8 microsteps per step, an 1.8
// degree stepper motor will have 1600 steps per full revolution.
#define STEPPER_BACKLASH     1    // 1 to enable, 0 to disable
#define BACKLASH_ANGLE     300    // 100 is 360 * 100/1600 = 22.5 degrees
                                  // I have a long nylon rod between stepper and
                                  // capacitor, hence the large backlash.
                                        

//-----------------------------------------------------------------------------
// Definitions for End Stop sensing
// If required, there are inputs from end-stop switches.  Here there are three
// potential scenarios, user selectable through the definition below:
//
// 1: Vacuum variable, no end-stop switches.  In this case one has to take care
//    that the stepper motor is just powerful enough to turn the capacitor but
//    not excessively more so. The Up/Down switches will not work beyond the
//    lowest/highest stored frequency/position.  To tune the capacitor beyond
//    an already "proven" range, one needs to turn the capacitor by using
//    the Encoder, and store new frequency/positions to extend the range.  
//    The downside of this method is that it only works if there is Frequency input
//    available from the radio ("smart" mode).
// 2: Vacuum variable, end-stop switchces.  All as 1) except no "intelligence" to
//    inhibit use of Up/Down buttons.  Can be used in "smart" mode with frequency
//    input from radio, or "dumb" mode with no frequency input.
// 3: Butterfly capacitor, no end-stops.  Otherwise same as 2).
#define  ENDSTOP_OPT         1
//
// The appropriate LCD indications below are automatically selected, based on
// the above choice.
// Indicate which mode is active in line four of the LCD upon startup
#if ENDSTOP_OPT == 1
#define STARTUPDISPLAY4    "Vacuum C, No EndStop"
#elif ENDSTOP_OPT == 2
#define STARTUPDISPLAY4    "End Stop Switches"
#elif ENDSTOP_OPT == 3
#define STARTUPDISPLAY4    "No End Stop Switches"
#endif

//-----------------------------------------------------------------------------
// Intro Message string to print to the first 2 lines of the LCD at startup
// Keep under 20 charecters per line
#define STARTUPDISPLAY1    "Magnetic Loop..."
#define STARTUPDISPLAY2    "...Controller"

//-----------------------------------------------------------------------------
// 5 + 4*NUM_PRESETS needs to be less than the total amount of EEPROM available 
#define MAX_PRESETS        100    // Max number of preset memories
//
// EEPROM settings Serial Number. Increment this number when firmware mods necessitate
// fresh "Factory Default Settings" to be forced into the EEPROM at first boot after
// an upgrade
#define COLDSTART_REF      0x01   // When started, the firmware examines this "Serial Number
                                  // and enforces factory reset if there is a mismatch.
                                  // This is useful if the EEPROM structure has been modified
//------------------------------------------------------------------------
// EEPROM structure:
//
// Addr 0, COLDSTART_REF or Rewrite BYTE (0xff indicates a "factory reset" rewrite all
// "memories" with default values upon reboot
// Addr 1-4, active FRQ (int32_t)
// Addr 5-8, active POS (int32_t)
// Addr 9-12, delta_Pos (int32_t)
// Addr 13-16, stepper_track (int32_t)
// Addr 17-(8xNUM_PRESETS) preset.Frq and preset.Pos pairs
// (each pair is 8 bytes, 2 x int32_t)
//------------------------------------------------------------------------


//
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// Definitions below are more cryptic - intended for the serious hacker! :)
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//

//-----------------------------------------------------------------------------
// Use this if compiling for the TF3LJ Teensy 2.0++ prototype unit
// If not, then using Teensy 3 or Teensy 3.1 type Microcontroller
#define PROTOTYPE      1

//-----------------------------------------------------------------------------  
// Assign pins to inputs and outputs (Arduino style)
//-----------------------------------------------------------------------------  
//
//-----------------------------------------------------------------------------  
// Normal configuration setup for the Teensy 3 / Teensy 3.1 Controller
#if !PROTOTYPE
// Switch input pins
// Note:  UART uses Pins 0 and 1
const int EnactSW = 23;
const int UpSW = 11;
const int DnSW = 12;
// End Stop Input Pins
#if ENDSTOP_OPT == 2
const int EndStopLower = 21;
const int EndStopUpper = 22;
#endif
// Rotary Encoder pins
const int EncI = 9;
const int EncQ = 10;
// LCD pins
const int LCD_D4 = 5;
const int LCD_D5 = 6;
const int LCD_D6 = 7;
const int LCD_D7 = 8;
const int LCD_RS = 2;
const int LCD_RW = 3;
const int LCD_E  = 4;
// Assign Output Pins to Stepper
const int PhA = 20;
const int D2A = 19;
const int D1A = 18;
const int D0A = 17;
const int PhB = 16;
const int D2B = 15;
const int D1B = 14;
const int D0B = 13;             // Pin 13 is the ledPin
#define TEENSY3        1        // 1 = ARM Cortex, not Atmel 8 bit Microcontroller
#define STUPIDENCODER  0
//-----------------------------------------------------------------------------  
// Setup for the initial TF3LJ Magloop Controller Prototype, using Teensy 2++
#else
// Pinouts reflecting the initial TF3LJ MagLoop Controller Prototype
// Switch input pins
// Note:  UART uses Pins 0 and 1
const int EnactSW = 4;
const int UpSW = 9;
const int DnSW = 8;
// Rotary Encoder pins
const int EncI = 7;
const int EncQ = 5;
// LCD pins
const int LCD_D4 = 14;
const int LCD_D5 = 15;
const int LCD_D6 = 16;
const int LCD_D7 = 17;
const int LCD_RS = 10;
const int LCD_RW = 11;
const int LCD_E  = 12;
// Assign Output Pins to Stepper
const int PhA = 27;
const int D2A = 26;
const int D1A = 25;
const int D0A = 24;
const int PhB = 23;
const int D2B = 22;
const int D1B = 21;
const int D0B = 20;
#define TEENSY3        0        // 1 = ARM Cortex, not Atmel 8 bit Microcontroller
#define STUPIDENCODER  1        // In my first application, using a Teensy 2.0++
                                // microcontroller, I stupidly assigned non-
                                // Interrupt capable pins to the Rotary Encoder.
#endif

//
//-----------------------------------------------------------------------------
// Miscellaneous software defines, functions and variables
//-----------------------------------------------------------------------------
//

//-----------------------------------------------------------------------------
// Flags

// DEFS for all kinds of Flags - The memory efficiency of doing this is probably
//                               wasted when using a 32 bit ARM CPU :-)
extern uint8_t         Status;
#define SHORT_PUSH     (1 << 0)    // Short Push Button Action
#define	LONG_PUSH      (1 << 1)    // Long Push Button Action
#define FRQ_TIMER      (1 << 2)    // FRQ_TIMER and FRQ_STORE are used to update EEPROM if
#define FRQ_STORE      (1 << 3)    //  frequency is stable for a while after a recent change.
#define FRQ_RADIO      (1 << 4)    // Frequency information received from Radio
#define BACKLASH       (1 << 5)    // Stepper Backlash Compensation Overshoot is active
//
#if ENDSTOP_OPT == 1               // Vacuum Capacitor, no end stops
#define FRQ_XRANGE     (1 << 6)    // Frequency is out of range
#define CAP_XRANGE     (1 << 7)    // capacitor is out of range
#else
#define END_LOWER      (1 << 6)    // Lower Endstop has been reached
#define END_UPPER      (1 << 7)    // Upper Endstop has been reached
#endif

// Operation Mode Flags
extern	uint8_t Menu_Mode;         // Which Menu Mode is active
#define	CONFIG         (1 << 0)

//-----------------------------------------------------------------------------
// Soft Reset
#if TEENSY3
// Teensy 3 style
#define RESTART_ADDR       0xE000ED0C
#define RESTART_VAL        0x5FA0004
#define SOFT_RESET() ((*(volatile uint32_t *)RESTART_ADDR) = (RESTART_VAL))
#else
// Atmel 8 bit microcontroller style
#define SOFT_RESET()       asm volatile("jmp 0x00000")
#endif

//-----------------------------------------------------------------------------
// Define a structure of two 32 bit integers to hold Frq and Pos information
typedef struct          // running Frequency and Position
{
  int32_t  Frq;
  int32_t  Pos;
} var_track;

// Bool stuff
#define	TRUE      1
#define FALSE     0
