#
# Simple code to Read Power and SWR from an ATmega168 based microcontroller
#   running the DG8SAQ / PE0FKO firmware, extended by TF3LJ
#
# Loftur E. Jonasson, TF3LJ - 2009-06-14
#
# Uses Python 2.5 and the PyUSB library
#
# Built on top of example code by Opendous Inc.
import usb

vendorid    = 0x16c0
productid   = 0x05dc
confignum   = 1
interfacenum= 0
timeout     = 1500


# Control Message bmRequestType Masks
REQDIR_HOSTTODEVICE = (0 << 7)
REQDIR_DEVICETOHOST = (1 << 7)
REQTYPE_STANDARD    = (0 << 5)
REQTYPE_CLASS       = (1 << 5)
REQTYPE_VENDOR      = (2 << 5)
REQREC_DEVICE       = (0 << 0)
REQREC_INTERFACE    = (1 << 0)
REQREC_ENDPOINT     = (2 << 0)
REQREC_OTHER        = (3 << 0)



# loop over all busses and all devices and find the one with the correct vendor and product IDs
# Note that if you have several of the same devices connected, it will select the last
###print "STARTED DeviceAccessPy"
busses = usb.busses()
for bus in busses:
    devices = bus.devices
    for dev in devices:
        if (dev.idVendor == vendorid) & (dev.idProduct == productid):
            founddev = dev
            foundbus = bus

# the device has been found, otherwise exit with error
bus = foundbus
dev = founddev

# open the device for communication
handle = dev.open()

# choose which of the device's configurations to use
handle.setConfiguration(confignum)

# choose which interface to interact with
handle.claimInterface(interfacenum)

buffer = () # initialize the read/write buffer
maxlen = 8 # size of buffer

bmRTmask = (REQDIR_DEVICETOHOST | REQTYPE_VENDOR | REQTYPE_STANDARD)

# read voltage out measurement from the ATmega168
buffer = handle.controlMsg(requestType = bmRTmask, request = 0x42, value = 0,
        index = 0, buffer = maxlen, timeout = timeout)

v_measured = (buffer[0] + 256 * buffer[1]) / 1130.0
power_out = v_measured * v_measured / 50.0
print "RAW ADC value PC3        %x hex" % (buffer[0] + 256 * buffer[1])
print "Vpeak measured           %.2f V" % (v_measured * 1.4142135)
print "Power Out                %.6f W" % power_out


# read voltage reflected measurement from the ATmega168
#buffer = handle.controlMsg(requestType = bmRTmask, request = 0x42, value = 0,
#        index = 1, buffer = maxlen, timeout = timeout)

#v_measured = (buffer[0] + 256 * buffer[1]) / 1130.0
#power_ref = v_measured * v_measured / 50.0
#print "RAW ADC value PC4        %x hex" % (buffer[0] + 256 * buffer[1])
#print "Vpeak_reflected measured %.2f V" % (v_measured * 1.4142135)
#print "Power Reflected          %.6f W" % power_ref

# read SWR calculated value from the ATmega168 (why calculate here, when it has already been done :)
#buffer = handle.controlMsg(requestType = bmRTmask, request = 0x42, value = 0,
#        index = 2, buffer = maxlen, timeout = timeout)
#
#calculated_swr = (buffer[0] + 256 * buffer[1])/100.0
#print "SWR                      %.2f" % calculated_swr

handle.releaseInterface()

