//************************************************************************
//**
//** Project......: USB controller firmware for the Softrock 6.3 SDR,
//**                   enhanced with the 9V1AL Motherboard v 3.6, an
//**                   external LPF bank and other essentials to create
//**                   an all singing and all dancing HF SDR amateur
//**                   radio transceiver
//**
//** Platform.....:    ATmega168 @ 16.0 MHz
//**
//**                   These functions poll the builtin 10 bit ADCs
//**
//** Initial version.: 2009-09-23, Loftur Jonasson, TF3LJ
//**                   Check the main.c file
//**
//************************************************************************

#include "_main.h"

/* ------------------------------------------------------------------------- */
/* ---------------------Initialise the ADC inputs -------------------------- */
/* ------------------------------------------------------------------------- */
void InitADC(void)
{
 
	ADCSRA |= (1 << ADEN) |         // Analog-Digital enable bit
    	      (1 << ADPS2)|         // set prescaler to 128    (clock / 128)
        	  (1 << ADPS1)|         // (doc Atmega168 2.8.2 p.255)
		  	  (1 << ADPS0);			// 
 
	DIDR0=0x0C;  					// Digital input disable for pins ADC3D and ADC4D

	ADMUX = ADC_P_OUT_PIN |(1<<ADLAR) | (1<<REFS0);// Select MUX,left adjust and select 5V ref
	ADCSRA |= (1 << ADSC);          // Start a conversion
}


/* ------------------------------------------------------------------------- */
/* ---- Scan the ADC inputs ---- */
/* ------------------------------------------------------------------------- */
// Read the ADC inputs. The TF3LJ ATmega168 board has ADC3 and ADC4 connected
//						It is possible to connect ADC5 as well for A/D input.
void pollADC(void)
{
	static uint16_t which=ADC_P_OUT, mux[2]={ADC_P_OUT_PIN, ADC_P_IN_PIN};
	static uint16_t adc_temp_reg[2];// Temporary register for AD measurements

	if (!(ADCSRA & (1 << ADSC)))	// Conversion is done, read, act and prepare for next
	{
		adc_temp_reg[which] = ADCW;
		if (which == 0) 			// Switch input and start a measurement cycle
			which++;
		else 
			which--;
		
		// Select MUX,left adjust and select 5V ref
		ADMUX = mux[which]|(1<<ADLAR) | (1<<REFS0);
		
		// Start a conversion
		ADCSRA |= (1 << ADSC);

		// If both Pout and Pin have been measured, then pass both at once to the
		// adc_read[] (this way we are sure that measured Power is slightly older
		// than measured Power_reflected
		if (which == 0)  // starting point, assume that there has been a full cycle
		{
			adc_read[0] = adc_temp_reg[0];
			adc_read[1] = adc_temp_reg[1];
		}
	}
}
